package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.HashSet;
import java.util.Set;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dao.IUserManagementDao;
import gov.va.genisis2.dto.UserDTO;
import gov.va.genisis2.exceptions.GenisisDAOException;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserApprover;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.util.Helper;
import gov.va.genisis2.vo.LdapUser;

/**
 * * The Class UserConverterTest.
 * 
 * @author Getaneh Kassahun
 *
 */
public class UserConverterTest extends AbstractMockMvcTests {

	/** The userManagementDao. */
	@Autowired
	private IUserManagementDao userManagementDao;

	/** The userConverter. */
	private UserConverter userConverter;

	/** The users. */
	private User user;

	/** Run before all test methods. */
	@Before
	public void setUp() {
		userConverter = new UserConverter();
	//TODO	userConverter.setUserApproverConverter(getMockUserApproverConverter());
		//TODO userConverter.setUserRoleTypeConverter(getMockUserRoleTypeConverter());
	}

	/** To test Convert method */
	@Test
	@Ignore
	public void testConvert() throws GenisisDAOException {

		user = userManagementDao.getUserDetailsByEmail("genisisad@gmail.com");
		UserDTO userDto = userConverter.convert(user);
		assertEquals("Francis", userDto.getFirstName());

		user = new User();
		userConverter.convert(user);
		assertNotNull((UserDTO) userConverter.convert(user));

		Set<UserRoleType> userRoleTypes = new HashSet<UserRoleType>(0);
		Set<UserApprover> userApprovers = new HashSet<>(0);
		UserRoleType userRoleType = null;
		UserApprover userApprover = null;
		userRoleTypes.add(userRoleType);
		userApprovers.add(userApprover);
		user = new User();
		user.setUserRoleTypes(userRoleTypes);
		user.setUserApproversForUserApproverId(userApprovers);
		user.setUserApproversForUserId(userApprovers);
		assertNotNull((UserDTO) userConverter.convert(user));

		UserRoleType userRoleType2 = new UserRoleType();
		RoleType roleType = null;
		userRoleType2.setRoleType(roleType);
		Set<UserRoleType> userRoleTypes2 = new HashSet<UserRoleType>(0);
		userRoleTypes2.add(userRoleType2);
		user.setUserRoleTypes(userRoleTypes2);
		assertNotNull((UserDTO) userConverter.convert(user));

	}

	/** To test Convert method */
	@Test
	public void testLdapConvert() {

		LdapUser ldapUser = Helper.getLdapUser();
		assertEquals("FirstName", userConverter.convert(ldapUser).getFirstName());
	}

	/** To test populate method */
	@Test
	public void testPopulate() {

		userConverter.populate(new User(), Helper.getLdapUser());
	}

	/** To test populateDisabledUser method */
	@Test
	public void testPopulateDisabledUser() {

		userConverter.populateDisabledUser(new User());
	}

}